#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Newton fractal bouncy ballsMod01.fsh  by  praggmars
//https://www.shadertoy.com/view/7dGSRw
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define SHOW_BALLS 0
#define PIXEL_ZERO 1
#define BALL_COLOR vec4(1.0f, 0.5f, 0.0f, 1.0f)

#define MAX_ITERATIONS   128
#define COLOR_SCALE      64.0f
#define NEWTON_STEP      vec2(1.0f, 0.0f)
#define TOLERANCE        1e-5f
#define ZOOM             1.0f
#define CENTER           vec2(0.0f, 0.0f)
#define SIZE_SCALING     0.0005f

struct Ball
{
    vec2 p;
    vec2 v;
    float r;
};
#define BALL_COUNT 5

const Ball balls[BALL_COUNT] = Ball[BALL_COUNT](
    Ball(vec2(100.80927f, 71.011841), vec2(91.7454071f, 202.384338f), 23.8096046f),
    Ball(vec2(782.947998f, 214.937714f), vec2(65.9425812f, -236.301651f), 29.2450104f),
    Ball(vec2(303.452515f, 244.819077f), vec2(113.372017f, -16.9429722f), 36.4064445f),
    Ball(vec2(142.07959f, 618.159912f), vec2(33.1328812f, -246.717346f), 49.0308456f),
    Ball(vec2(1159.59851f, 604.708252f), vec2(93.8061142f, -80.5465546f), 48.7150116f)
);

vec2 GetBallPosition(in Ball ball)
{
    float scale = length(iResolution.xy) * SIZE_SCALING;
    vec2 rect = iResolution.xy - (2.0f * ball.r * scale);
    float t = iTime;
    
    return abs(mod(ball.p + ball.v * t * scale, 2.0f * rect) - rect) + ball.r * scale;
}

vec2 ComplexMul(vec2 z1, vec2 z2)
{
	return vec2(z1.x * z2.x - z1.y * z2.y, z1.x * z2.y + z1.y * z2.x);
}
vec2 ComplexDiv(vec2 z1, vec2 z2)
{
	return vec2(z1.x * z2.x + z1.y * z2.y, z1.y * z2.x - z1.x * z2.y) / (z2.x * z2.x + z2.y * z2.y);
}

float ToRatio(float iterations, float dist)
{
    return iterations / COLOR_SCALE;
}

vec4 ToColor(float ratio, int zero)
{
	float R = abs(ratio * 6.0f - 3.0f) - 1.0f;
	float G = 2.0f - abs(ratio * 6.0f - 2.0f);
	float B = 2.0f - abs(ratio * 6.0f - 4.0f);
    
    /*const float PI = 3.141592654f;
    float phase = 1.85f;
    R = sin(phase + ratio * 2.0f * PI) * 0.5f + 0.5f;
    B = sin(phase + ratio * 2.0f * PI + PI * 2.0f / 3.0f) * 0.5f + 0.5f;
    G = sin(phase + ratio * 2.0f * PI + PI * 4.0f / 3.0f) * 0.5f + 0.5f;*/
    
	return vec4(clamp(vec3(R, G, B), 0.0f, 1.0f)*(1.0f - R * 0.49f), 1.0f);
}

vec2 Transform(vec2 screen)
{
	return (screen * 2.0f - iResolution.xy) / (iResolution.y * ZOOM) + CENTER;
}

vec4 FunctionColor(vec2 coord)
{
#if PIXEL_ZERO
    vec2 zeros[BALL_COUNT + 1];
    vec2 z = coord;
    zeros[BALL_COUNT] = z;
    int ballCount = BALL_COUNT + 1;
#else
    vec2 zeros[BALL_COUNT];
    int ballCount = BALL_COUNT;
#endif
    for (int i = 0; i < BALL_COUNT; i++)
    {
        zeros[i] = Transform(GetBallPosition(balls[i]));
#if PIXEL_ZERO
        z += zeros[i];
    }
    z /= float(BALL_COUNT + 1);
#else
    }
	vec2 z = coord;
#endif
    
	for (int i = 0; i < MAX_ITERATIONS; i++)
	{
        vec2 funcValue = z - zeros[0];
        for (int j = 1; j < ballCount; j++)
            funcValue = ComplexMul(funcValue, z - zeros[j]);

        vec2 derivValue = vec2(0.0f, 0.0f);
        for (int j = 0; j < ballCount; j++)
        {
            vec2 tmp = vec2(1.0f, 0.0f);
            for (int k = 0; k < ballCount; k++)
                if (j != k)
                    tmp = ComplexMul(tmp, z - zeros[k]);
            derivValue += tmp;
        }
        
		z -= ComplexMul(NEWTON_STEP, ComplexDiv(funcValue, derivValue));

        for (int j = 0; j < ballCount; j++)
        {
            float dist = length(z - zeros[j]);
            if (dist < TOLERANCE)
                return ToColor(ToRatio(float(i), dist), j);
        }
	}
	return vec4(0.0f, 0.0f, 0.0f, 1.0f);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    fragColor = FunctionColor(Transform(fragCoord));
    
#if SHOW_BALLS
    float scale = length(iResolution.xy) * SIZE_SCALING;
    for (int i = 0; i < BALL_COUNT; i++)
    {
        float d = length(GetBallPosition(balls[i]) - fragCoord);
        if (d < balls[i].r * scale && d > balls[i].r * 0.7f * scale)
        {
            fragColor = BALL_COLOR;
            break;
        }
    }
#endif
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

